<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\FrontController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

/*Route::get('/', function () {
    return view('pages/front/home');
});*/


Route::get('/', [FrontController::class, 'showHomePage']);
Route::get('/about', [FrontController::class, 'showAboutPage']);
Route::get('/contact',[FrontController::class, 'showContactPage']);
Route::get('/synonyms',[FrontController::class, 'showSynPage']);
Route::get('/pronouncation', [FrontController::class, 'showProPage']);
Route::get('/copyright',[FrontController::class, 'showDcmaPage']);
Route::get('/privacy',[FrontController::class, 'showPrivacyPage']);
Route::get('/termsconditions',[FrontController::class, 'showTermsPage']);
Route::post('/postContact',[FrontController::class, 'postContactData']);

Route::post('/searchWord',[FrontController::class, 'postSearchWord']);
Route::get('/searchWordHome',[FrontController::class, 'getSearchWordLink']);
Route::get('/searchWordSyn',[FrontController::class, 'getSearchWordLink']);
Route::get('/searchWordPro',[FrontController::class, 'getSearchWordLink']);



/*Route::middleware(['auth:sanctum', 'verified'])->get('/dashboard', function () {
    return view('dashboard');
})->name('dashboard');*/

Route::group(['middleware' => ['auth:sanctum', 'verified']], function()
{
   /*Route::get('/admin/dashboard', function()
   	{  
   		return view('dashboard');
   	})->name('dashboard');*/
  Route::get('/admin/dashboard',[AdminController::class, 'showDashboardPage']);
 
  Route::get('/admin/changepassword',[AdminController::class, 'showChangePassword']);
  Route::post('/admin/updatePassword',[AdminController::class, 'updatePassword']);
  Route::get('/admin/aboutus',[AdminController::class, 'showAboutPage']);
  Route::get('/admin/dcma',[AdminController::class, 'showDcmaPage']);
  Route::get('/admin/privacypolicy',[AdminController::class, 'showPrivacyPolicyPage']);
  Route::get('/admin/terms',[AdminController::class, 'showTermsPage']);
  Route::post('/admin/uploadimage',[AdminController::class, 'uploadImage']);
  Route::post('/admin/updateAbout',[AdminController::class, 'updateAboutPage']);
  Route::post('/admin/updateDcma',[AdminController::class, 'updateDcmaPage']);
  Route::post('/admin/updatePrivacy',[AdminController::class, 'updatePrivacyPage']);
  Route::post('/admin/updateTerms',[AdminController::class, 'updateTermsPage']);
  Route::get('/admin/apiKey',[AdminController::class, 'showApiKeyPage']);
  Route::post('/admin/updateApiKey',[AdminController::class, 'updateApiKeyPage']);
  Route::get('/admin/headerAds',[AdminController::class, 'showHeaderAdsPage']);
  Route::post('/admin/updateHeaderAds',[AdminController::class, 'updateHeaderAdsPage']);
  Route::get('/admin/footerAds',[AdminController::class, 'showFooterAdsPage']);
  Route::post('/admin/updateFooterAds',[AdminController::class, 'updateFooterAdsPage']);
   Route::get('/admin/leftAds',[AdminController::class, 'showLeftAdsPage']);
  Route::post('/admin/updateLeftAds',[AdminController::class, 'updateLeftAdsPage']);
   Route::get('/admin/rightAds',[AdminController::class, 'showRightAdsPage']);
  Route::post('/admin/updateRightAds',[AdminController::class, 'updateRightAdsPage']);
  Route::get('/admin/headSection',[AdminController::class, 'showHeadSectionPage']);
  Route::post('/admin/updateHeadSection',[AdminController::class, 'updateHeadSectionPage']);


  Route::get('/admin/contactList',[AdminController::class, 'showContactListPage']);
  Route::post('/admin/deleteContact',[AdminController::class, 'deleteContact']);
  Route::get('/admin/addWord',[AdminController::class, 'showAddWordPage']);
  Route::post('/admin/postWord',[AdminController::class, 'postWord']);
  Route::get('/admin/wordList',[AdminController::class, 'showWordListPage']);
  
  Route::post('/admin/deleteWord',[AdminController::class, 'deleteWord']);


 

});
