<?php

namespace App\Http\Controllers;

//use App\Models\Admin;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Hash;
use DB;
class AdminController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

  
  // Use for show Dashbaord Page

  public function showDashboardPage()
   {
     
     $total_words = DB::table('words')->distinct('word')->count('word');
     $total_search_done =DB::table('word_search')->get()->sum("total");
      return view('dashboard',['total_words'=>$total_words,'total_search_done'=>$total_search_done]);

   }


  // Use for show change password page
   public function showChangePassword()
   {
     
      return view('profile.changepassword');

   }

  // Use for update admin password 
   public function updatePassword(Request $request)
   {
   	       $user               =           Auth::user();
           $request->validate(
            [
                'old_password'              =>      'required',
                'new_password'          =>      'required|alpha_num|min:8',
                'confirm_password'  =>      'required|same:new_password'
            ]
        );
 
        $users = DB::table('users')->where('id', $user->id)->first();

       if(!is_null($users))
        {

        	 $old_password = $request->old_password;
    $new_password = $request->new_password;
    $confirm_password = $request->confirm_password;
            if(!Hash::check($old_password, $user->password))
            {

              return back()->with("failed", "Old Password Does not Match"); 	
             //return redirect('changepassword')->with('Error', 'Old Password Does not Match');
            }
            else
            {
          
            $securePassword = array('password'=>bcrypt($new_password));
            DB::table('users')->where('id',$user->id)->update($securePassword);
            
            return redirect('/admin/login')->with('success', 'Your password succuessfully changed');
            }
            
        }

        else
        {
            return back()->with("failed", "Alert! Failed to update password");
        }    

   }


 
 // Use for show about page content
   public function showAboutPage()
   {
     $aboutus =  DB::table('front_page')->where('id',1)->first();
            
      return view('pages.about',['aboutus'=>$aboutus]);

   }
    
 // Use for update about page content
   public function updateAboutPage(Request $request)
   {
     
         $request->validate(
            [
                'title'              =>      'required',
                'content'          =>      'required'
            ]
        );

        
       $updateData=['title'=>$request->title,'content'=>$request->content];

       DB::table('front_page')->where('id',1)->update($updateData);
        return redirect('/admin/aboutus')->with('success', 'Succuessfully saved');
           
   }



  // Use for show dcma copyright page content
   public function showDcmaPage()
   {
     $dcma =  DB::table('front_page')->where('id',2)->first();
            
      return view('pages.dcma',['dcma'=>$dcma]);

   }

  // Use for update dcma copyright page content
   public function updateDcmaPage(Request $request)
   {
     
         $request->validate(
            [
                'title'              =>      'required',
                'content'          =>      'required'
            ]
        );
     
        $updateData=['title'=>$request->title,'content'=>$request->content];

       DB::table('front_page')->where('id',2)->update($updateData);
        return redirect('/admin/dcma')->with('success', 'Succuessfully saved');
           
   }


 // Use for show privacy policy page content
   public function showPrivacyPolicyPage()
   {
     $privacy =  DB::table('front_page')->where('id',3)->first();
            
      return view('pages.privacy',['privacy'=>$privacy]);

   }

 // Use for update privacy policy page content
   public function updatePrivacyPage(Request $request)
   {
     
         $request->validate(
            [
                'title'              =>      'required',
                'content'          =>      'required'
            ]
        );
     
        $updateData=['title'=>$request->title,'content'=>$request->content];

       DB::table('front_page')->where('id',3)->update($updateData);
        return redirect('/admin/privacypolicy')->with('success', 'Succuessfully saved');
           
   }

// Use for show terms and condition page content
   public function showTermsPage()
   {
     $terms =  DB::table('front_page')->where('id',4)->first();
            
      return view('pages.terms',['terms'=>$terms]);

   }

// Use for update terms and condition page content
   public function updateTermsPage(Request $request)
   {
     
         $request->validate(
            [
                'title'              =>      'required',
                'content'          =>      'required'
            ]
        );
     
        $updateData=['title'=>$request->title,'content'=>$request->content];

       DB::table('front_page')->where('id',4)->update($updateData);
        return redirect('/admin/terms')->with('success', 'Succuessfully saved');
           
   }



   public function uploadImage(Request $request)
   {
    $image = $request->image;
    if(!empty($image))
     {  
        $valid_exts = array('jpeg', 'jpg', 'png');
                                   
	    // get file extension
	    $ext = $image->getClientOriginalExtension();

       if (in_array($ext, $valid_exts)) 
      {    
        $destinationPath = public_path().'/uploads/';
        $filename = str_random(6).'_'.$image->getClientOriginalName();
        //$path = url('/').'/uploads/'.'offers_image/'.$filename;
        $image->move($destinationPath, $filename);
        
        echo $thumb = public_path().'/uploads/'.$filename;
         echo  $thumbpath = url('/').'/uploads/'.$filename;
      
       } 
   
      }
   }


  // Use for show api key on page
   public function showApiKeyPage()
   {
       $apiKey =  DB::table('front_page')->where('id',5)->first();
            
      return view('pages.apikey',['apiKey'=>$apiKey]);


   }  


// Use for update api key on page
   public function updateApiKeyPage(Request $request)
   {
     
         $request->validate(
            [
                'api_key'              =>      'required'
            ]
        );
     
        $updateData=['api_key'=>$request->api_key];

       DB::table('front_page')->where('id',5)->update($updateData);
        return redirect('/admin/apiKey')->with('success', 'Succuessfully saved');
           
   }

// Use for show  header ads on page
   public function showHeaderAdsPage()
   {
       $header_ads =  DB::table('front_page')->where('id',6)->first();
            
      return view('pages.header_ads',['header_ads'=>$header_ads]);


   }  


// Use for update header ads on page
   public function updateHeaderAdsPage(Request $request)
   {
     
        /* $validator = Validator::make($request->all(),
            [
                'header_ads'              =>      'required'
            ]
        );*/
     
    
      $header_ads= $request->header_ads;

        $header_ads = str_replace('keywrd','script',$header_ads);          
     
        $updateData=['header_ads'=>$header_ads];
        if ($validator->passes()) {

        DB::table('front_page')->where('id',6)->update($updateData);
         return response()->json(['success'=>"Succuessfully saved"]);
      
        }

        return response()->json(['error'=>$validator->errors()]);

        //return redirect('/headerAds')->with('success', 'Succuessfully saved');
           
   }


// Use for show footer ads on page
   public function showFooterAdsPage()
   {
       $footer_ads =  DB::table('front_page')->where('id',6)->first();
            
      return view('pages.footer_ads',['footer_ads'=>$footer_ads]);


   }  


// Use for update footer ads on page
   public function updateFooterAdsPage(Request $request)
   {
     
      /*$validator = Validator::make($request->all(),
            [
                'footer_ads'              =>      'required'
            ]
        );*/
     
    
      $footer_ads= $request->footer_ads;

        $footer_ads = str_replace('keywrd','script',$footer_ads);          
     
          $updateData=['footer_ads'=>$footer_ads];

        if ($validator->passes()) {

        
         DB::table('front_page')->where('id',6)->update($updateData);
       
         return response()->json(['success'=>"Succuessfully saved"]);
      
        }

        return response()->json(['error'=>$validator->errors()]);
 
     
        //return redirect('/footerAds')->with('success', 'Succuessfully saved');
           
   }


// Use for show left ads on page
   public function showLeftAdsPage()
   {
       $left_ads =  DB::table('front_page')->where('id',6)->first();
            
      return view('pages.left_ads',['left_ads'=>$left_ads]);


   }  


// Use for update left ads on page
   public function updateLeftAdsPage(Request $request)
   {
     
        /*   $validator = Validator::make($request->all(),
            [
                'left_ads'              =>      'required'
            ]
        );*/
     
    
       $left_ads= $request->left_ads;

        $left_ads = str_replace('keywrd','script',$left_ads);          
     
        $updateData=['left_ads'=>$left_ads];

        if ($validator->passes()) {

        
         DB::table('front_page')->where('id',6)->update($updateData);
       
         return response()->json(['success'=>"Succuessfully saved"]);
      
        }

        return response()->json(['error'=>$validator->errors()]);
 
     
 

   }

// Use for show right ads on page
   public function showRightAdsPage()
   {
       $right_ads =  DB::table('front_page')->where('id',6)->first();
            
      return view('pages.right_ads',['right_ads'=>$right_ads]);


   }  


// Use for show right ads on page
   public function updateRightAdsPage(Request $request)
   {
     
           /* $validator = Validator::make($request->all(),
            [
                'right_ads'              =>      'required'
            ]
        );*/
     
    
      $right_ads= $request->right_ads;

        $right_ads = str_replace('keywrd','script',$right_ads);          
     
          $updateData=['right_ads'=>$right_ads];

        if ($validator->passes()) {

        
         DB::table('front_page')->where('id',6)->update($updateData);
       
         return response()->json(['success'=>"Succuessfully saved"]);
      
        }

        return response()->json(['error'=>$validator->errors()]);
 
     
     
   }



 

// Use for show head section on page
   public function showHeadSectionPage()
   {
       $head_section =  DB::table('front_page')->where('id',6)->first();
            
      return view('pages.head_section',['head_section'=>$head_section]);


   }  


// Use for show head section on page
   public function updateHeadSectionPage(Request $request)
   {
     
           /* $validator = Validator::make($request->all(),
            [
                'head_section'              =>      'required',
                'meta_keyword'              =>      'required',
                'meta_description'              =>      'required'
            ]
        );*/
     
    
        $head_section= $request->head_section;

        $head_section = str_replace('keywrd','script',$head_section);          
     
        $updateData=['head_section'=>$head_section,'meta_keyword'=>$request->meta_keyword,'meta_description'=>$request->meta_description];

        if ($validator->passes()) {

        
         DB::table('front_page')->where('id',6)->update($updateData);
       
         return response()->json(['success'=>"Succuessfully saved"]);
      
        }

        return response()->json(['error'=>$validator->errors()]);
 
     
     
   }




// Use for show contact list on page
  public function showContactListPage()
   {
       $contact_list =  DB::table('contact')->orderBy('id', 'DESC')->get();
             
      return view('pages.contact_list',['contact_list'=>$contact_list]);


   }  

// Use for delete contact on page
   public function deleteContact(Request $request)
   {
      $id=$request->id;

      DB::table('contact')->where('id', $id)->delete();
      return redirect('/admin/contactList')->with('success', 'Deleted succuessfully');
   
   }

   

// Use for show add word on page
  public function showAddWordPage()
   {
             
      return view('pages.add_word');


   }  



// Use for add word on page
   public function postWord(Request $request)
   {
     
              $validatedData = $request->validate([
                'word' => 'required',
              
              ]);     
    
      
         $word = trim($request->word);
        
         $word =explode(",", $word);
         
         foreach ($word as $value) 
         {
          DB::table('words')->insert(array('word'=>$value));
       
         }

        
        return redirect('admin/wordList')->with('success', 'Succuessfully saved');
       
       
   }




// Use for show word list on page
  public function showWordListPage()
   {
       $word_list =  DB::table('words')->orderBy('id', 'DESC')->get();
             
      return view('pages.word_list',['word_list'=>$word_list]);


   }  



// Use for delete word from  word list
   public function deleteWord(Request $request)
   {
      $id=$request->id;

      DB::table('words')->where('id', $id)->delete();
      return redirect('/admin/wordList')->with('success', 'Deleted succuessfully');
   
   }




}
