@extends('layouts.default')
@section('content')
<main id="main">
  <div class="col-lg-12">
    <?php  echo $ads->header_ads;?>
  </div>
  <!-- ======= Pricing Section ======= -->
  <section id="pricing" class="pricing section-bg">
    <div class="container-fluid">
      <div class="row">
        <div class="col-md-2"><?php echo $ads->left_ads;?>  </div>
        <div class="col-md-8">
          <div class="col-md-12">
            <div class="box" data-aos="zoom-in">
              <div class="row">
                <div class="col-md-12">
                  <ul class='converttabs'>
                    <li><a href="{{ URL::to('forex') }}" class="<?php echo Request::is('forex') ? 'active-page' : '' ?>">Forex</a></li>
                    <li><a href="{{ URL::to('length') }}" class="<?php echo Request::is('length') ? 'active-page' : '' ?>">Length</a></li>
                    <li><a href="{{ URL::to('volume') }}" class="<?php echo Request::is('volume') ? 'active-page' : '' ?>">Volume</a></li>
                    <li><a href="{{ URL::to('mass') }}" class="<?php echo Request::is('mass') ? 'active-page' : '' ?>">Mass</a></li>
                    <li><a href="{{ URL::to('area') }}" class="<?php echo Request::is('area') ? 'active-page' : '' ?>">Area</a></li>
                    <li><a href="{{ URL::to('speed') }}" class="<?php echo Request::is('speed') ? 'active-page' : '' ?>">Speed</a></li>
                  </ul>
                </div>
                <div class="col-md-4 homegrid">
                  <h2>Length</h2>
                  <form id="conv_length" action="javascript:void(0)">
                    <div class="form-group">
                      <div class="row">
                        <div class="col-md-10 col-10">
                          <input type="number" placeholder="I want to convert" id="length_amount" name="length_amount" aria-label="Amount"  class="form-control"/>
                          
                        </div>
                        <div class="col-md-2 searchbtncol col-2">
                          <button type="button" id="length_btn" name="length_btn" class="btn btn-warning"><i class="fa fa-search"></i></button>
                          
                        </div>
                        <span id="length_amount_err" class="frm-err"></span>
                        
                      </div>
                      
                    </div>
                    <div class="form-group">
                      <select name="unit_from" id="from_length" class="form-control dropdown-first">
                        <option value="">Select Length</option>
                        <option disabled="disabled" class="title">Metric</option>
                        <option value="km">Kilometre (km)</option>
                        <option value="m">Metre (m)</option>
                        <option value="dm">Decimetre (dm)</option>
                        <option value="cm">Centimetre (cm)</option>
                        <option value="mm">Millimetre (mm)</option>
                        <option value="µm">Micrometre (µm)</option>
                        <option value="nm">Nanometre (nm)</option>
                        <option value="Å">Angstrom (Å)</option>
                        <option disabled="disabled">&nbsp;</option>
                        <option disabled="disabled" class="title">British/American</option>
                        <option value="league">League</option>
                        <option value="mi">Mile (mi)</option>
                        <option value="furlong">Furlong</option>
                        <option value="chain">Chain</option>
                        <option value="rd">Rod (rd)</option>
                        <option value="yd">Yard (yd)</option>
                        <option value="ft">Foot (ft)</option>
                        <option value="link">Link</option>
                        <option value="hand">Hand</option>
                        <option value="in">Inch (in)</option>
                        <option value="line">Line</option>
                        <option value="mil">Mil (mil)</option>
                        <option value="thou">Thou (thou)</option>
                        <option disabled="disabled">&nbsp;</option>
                        <option disabled="disabled" class="title">Nautical</option>
                        <option value="sea mile">Nautical mile</option>
                        <option value="fathom">Fathom</option>
                        <option disabled="disabled">&nbsp;</option>
                        <option disabled="disabled" class="title">Astronomical</option>
                        <option value="pc">Parsec (pc)</option>
                        <option value="light year">Light year</option>
                        <option value="AE">Astronomical unit (AE)</option>
                        <option value="light minute">Light minute</option>
                        <option value="light second">Light second</option>
                      </select>
                      <span id="from_length_err" class="frm-err"></span>
                      <a href="javascript:void(0)" class="swapstyle swap-length">To <img src="swap.jpg" class="swap_img"></a>
                    </div>
                    <div class="form-group">
                      <select name="unit_to" id="to_length" class="form-control">
                        <option value="">Select Length</option>
                        <option disabled="disabled" class="title">Metric</option>
                        <option value="km">Kilometre (km)</option>
                        <option value="m">Metre (m)</option>
                        <option value="dm">Decimetre (dm)</option>
                        <option value="cm">Centimetre (cm)</option>
                        <option value="mm">Millimetre (mm)</option>
                        <option value="µm">Micrometre (µm)</option>
                        <option value="nm">Nanometre (nm)</option>
                        <option value="Å">Angstrom (Å)</option>
                        <option disabled="disabled">&nbsp;</option>
                        <option disabled="disabled" class="title">British/American</option>
                        <option value="league">League</option>
                        <option value="mi">Mile (mi)</option>
                        <option value="furlong">Furlong</option>
                        <option value="chain">Chain</option>
                        <option value="rd">Rod (rd)</option>
                        <option value="yd">Yard (yd)</option>
                        <option value="ft">Foot (ft)</option>
                        <option value="link">Link</option>
                        <option value="hand">Hand</option>
                        <option value="in">Inch (in)</option>
                        <option value="line">Line</option>
                        <option value="mil">Mil (mil)</option>
                        <option value="thou">Thou (thou)</option>
                        <option disabled="disabled">&nbsp;</option>
                        <option disabled="disabled" class="title">Nautical</option>
                        <option value="sea mile">Nautical mile</option>
                        <option value="fathom">Fathom</option>
                        <option disabled="disabled">&nbsp;</option>
                        <option disabled="disabled" class="title">Astronomical</option>
                        <option value="pc">Parsec (pc)</option>
                        <option value="light year">Light year</option>
                        <option value="AE">Astronomical unit (AE)</option>
                        <option value="light minute">Light minute</option>
                        <option value="light second">Light second</option>
                        
                      </select>
                      <span id="to_length_err" class="frm-err"></span>
                      
                    </div>
                    
                    
                    <div class="result_container">
                      <div class="result" id="div_length"></div>
                    </div>
                  </form>
                </div>
                <div class="col-md-4 homegrid">
                  <h2>Volume</h2>
                  <form id="conv_volume" action="javascript:void(0)">
                    <div class="form-group">
                      <div class="row">
                        <div class="col-md-10 col-10">
                          <input type="number" id="volume_amount" name="volume_amount" aria-label="Amount"  placeholder="I want to convert"  class="form-control"/>
                          
                        </div>
                        <div class="col-md-2 searchbtncol col-2">
                          <button type="button" id="volume_btn" name="volume_btn" class="btn btn-warning"><i class="fa fa-search"></i></button>
                          
                        </div>
                        <span id="volume_amount_err" class="frm-err"></span>
                      </div>
                      
                    </div>
                    <div class="form-group">
                      <select name="unit_from" id="from_volume" class="form-control dropdown-first">
                        <option value="">Select Volume</option>
                        <option disabled="disabled" class="title">Metric</option>
                        <option value="km³">Cubic kilometer</option>
                        <option value="m³">Cubic meter</option>
                        <option value="hl">Hectoliter</option>
                        <option value="decaliter">Decaliter</option>
                        <option value="dm³">Cubic decimeter</option>
                        <option value="l">Litre (l)</option>
                        <option value="dl">Deciliter</option>
                        <option value="cl">Centiliter</option>
                        <option value="cm³">Cubic centimeter</option>
                        <option value="ml">Milliliter</option>
                        <option value="mm³">Cubic millimeter</option>
                        <option value="µl">Microliter</option>
                        <option disabled="disabled">&nbsp;</option>
                        <option disabled="disabled" class="title">British imperial liquid/dry</option>
                        <option value="barrel:2">Barrel</option>
                        <option value="bu:1">Bushel (bu)</option>
                        <option value="pk">Peck (pk)</option>
                        <option value="gal:2">Gallon (gal)</option>
                        <option value="qt:1">Quart (qt)</option>
                        <option value="pt:2">Pint (pt)</option>
                        <option value="oz:1">Fluid ounce (oz)</option>
                        <option disabled="disabled">&nbsp;</option>
                        <option disabled="disabled" class="title">U.S. liquid measure</option>
                        <option value="acre foot">Acre foot</option>
                        <option value="yd³">Cubic yard (yd³)</option>
                        <option value="barrel">Barrel</option>
                        <option value="ft³">Cubic foot (ft³)</option>
                        <option value="gal:1">Gallon (gal)</option>
                        <option value="qt:2">Quart (qt)</option>
                        <option value="pt">Pint (pt)</option>
                        <option value="gill">Gill</option>
                        <option value="oz">Fluid ounce (oz)</option>
                        <option value="in³">Cubic inch (in³)</option>
                        <option value="fluid dram">Fluid dram</option>
                        <option value="minim">Minim</option>
                        <option disabled="disabled">&nbsp;</option>
                        <option disabled="disabled" class="title">U.S. dry measure</option>
                        <option value="barrel:1">Barrel</option>
                        <option value="bu">Bushel (bu)</option>
                        <option value="pk:1">Peck (pk)</option>
                        <option value="gal">Gallon (gal)</option>
                        <option value="qt">Quart (qt)</option>
                        <option value="pt:1">Pint (pt)</option>
                        <option value="gill:1">Gill</option>
                        <option value="FBM">Board foot (FBM)</option>
                        <option disabled="disabled">&nbsp;</option>
                        <option disabled="disabled" class="title">Japanese</option>
                        <option value="koku:1">Koku</option>
                        <option value="to">To</option>
                        <option value="sho">Sho</option>
                        <option value="go">Go</option>
                        <option disabled="disabled">&nbsp;</option>
                        <option disabled="disabled" class="title">Cooking (U.S.)</option>
                        <option value="cup">Cup</option>
                        <option value="tablespoon:1">Tablespoon</option>
                        <option value="teaspoon:1">Teaspoon</option>
                        <option disabled="disabled">&nbsp;</option>
                        <option disabled="disabled" class="title">Cooking (metric)</option>
                        <option value="tablespoon">Tablespoon</option>
                        <option value="teaspoon">Teaspoon</option>
                        <option value="spice measure">Spice measure</option>
                      </select>
                      
                      <span id="from_volume_err" class="frm-err"></span>
                      <a href="javascript:void(0)" class="swapstyle swap-volume">To <img src="swap.jpg"class="swap_img"></a>
                    </div>
                    <div class="form-group">
                      
                      <select name="unit_to" id="to_volume" class="form-control">
                        <option value="">Select Volume</option>
                        <option disabled="disabled" class="title">Metric</option>
                        <option value="km³">Cubic kilometer</option>
                        <option value="m³">Cubic meter</option>
                        <option value="hl">Hectoliter</option>
                        <option value="decaliter">Decaliter</option>
                        <option value="dm³">Cubic decimeter</option>
                        <option value="l">Litre (l)</option>
                        <option value="dl">Deciliter</option>
                        <option value="cl">Centiliter</option>
                        <option value="cm³">Cubic centimeter</option>
                        <option value="ml">Milliliter</option>
                        <option value="mm³">Cubic millimeter</option>
                        <option value="µl">Microliter</option>
                        <option disabled="disabled">&nbsp;</option>
                        <option disabled="disabled" class="title">British imperial liquid/dry</option>
                        <option value="barrel:2">Barrel</option>
                        <option value="bu:1">Bushel (bu)</option>
                        <option value="pk">Peck (pk)</option>
                        <option value="gal:2">Gallon (gal)</option>
                        <option value="qt:1">Quart (qt)</option>
                        <option value="pt:2">Pint (pt)</option>
                        <option value="oz:1">Fluid ounce (oz)</option>
                        <option disabled="disabled">&nbsp;</option>
                        <option disabled="disabled" class="title">U.S. liquid measure</option>
                        <option value="acre foot">Acre foot</option>
                        <option value="yd³">Cubic yard (yd³)</option>
                        <option value="barrel">Barrel</option>
                        <option value="ft³">Cubic foot (ft³)</option>
                        <option value="gal:1">Gallon (gal)</option>
                        <option value="qt:2">Quart (qt)</option>
                        <option value="pt">Pint (pt)</option>
                        <option value="gill">Gill</option>
                        <option value="oz">Fluid ounce (oz)</option>
                        <option value="in³">Cubic inch (in³)</option>
                        <option value="fluid dram">Fluid dram</option>
                        <option value="minim">Minim</option>
                        <option disabled="disabled">&nbsp;</option>
                        <option disabled="disabled" class="title">U.S. dry measure</option>
                        <option value="barrel:1">Barrel</option>
                        <option value="bu">Bushel (bu)</option>
                        <option value="pk:1">Peck (pk)</option>
                        <option value="gal">Gallon (gal)</option>
                        <option value="qt">Quart (qt)</option>
                        <option value="pt:1">Pint (pt)</option>
                        <option value="gill:1">Gill</option>
                        <option value="FBM">Board foot (FBM)</option>
                        <option disabled="disabled">&nbsp;</option>
                        <option disabled="disabled" class="title">Japanese</option>
                        <option value="koku:1">Koku</option>
                        <option value="to">To</option>
                        <option value="sho">Sho</option>
                        <option value="go">Go</option>
                        <option disabled="disabled">&nbsp;</option>
                        <option disabled="disabled" class="title">Cooking (U.S.)</option>
                        <option value="cup">Cup</option>
                        <option value="tablespoon:1">Tablespoon</option>
                        <option value="teaspoon:1">Teaspoon</option>
                        <option disabled="disabled">&nbsp;</option>
                        <option disabled="disabled" class="title">Cooking (metric)</option>
                        <option value="tablespoon">Tablespoon</option>
                        <option value="teaspoon">Teaspoon</option>
                        <option value="spice measure">Spice measure</option>
                      </select>
                      <span id="to_volume_err" class="frm-err"></span>
                      
                    </div>
                    
                    <div class="result_container">
                      <div class="result" id="div_volume"></div>
                    </div>
                  </form>
                </div>
                <div class="col-md-4 homegrid">
                  <h2>Currency</h2>
                  <form id="conv_currency" action="javascript:void(0)">
                    <div class="form-group">
                      <div class="row">
                        <div class="col-md-10 col-10">
                          <input type="number" id="currency_amount" name="currency_amount" aria-label="Amount"  class="form-control" placeholder="I want to convert" />
                          
                        </div>
                        <div class="col-md-2 searchbtncol col-2">
                          <button type="button" id="currency_btn" name="currency_btn" class="btn btn-warning"><i class="fa fa-search"></i></button>
                          
                        </div>
                        <span id="currency_amount_err" class="frm-err"></span>
                      </div>
                      
                    </div>
                    <div class="form-group">
                      <select name="unit_from" id="from_currency" class="form-control dropdown-first">
                        <option value="">Select Currency</option>
                        
                        <option disabled="disabled" class="title">Most popular / recent</option>
                        <option value="JPY">Japanese yen (JPY)</option>
                        <option value="INR">Indian rupee (INR)</option>
                        <option value="GBP">British pound (GBP)</option>
                        <option value="EUR">Euro (EUR)</option>
                        <option value="USD">U.S. dollar (USD)</option>
                        <option disabled="disabled" class="title">All currencies</option>
                        <option value="AFA">Afghan Afghani</option>
                        <option value="ALL">Albanian Lek</option>
                        <option value="DZD">Algerian Dinar</option>
                        <option value="AOA">Angolan Kwanza</option>
                        <option value="ARS">Argentine Peso</option>
                        <option value="AMD">Armenian Dram</option>
                        <option value="AWG">Aruban Florin</option>
                        <option value="AUD">Australian Dollar</option>
                        <option value="AZN">Azerbaijani Manat</option>
                        <option value="BSD">Bahamian Dollar</option>
                        <option value="BHD">Bahraini Dinar</option>
                        <option value="BDT">Bangladeshi Taka</option>
                        <option value="BBD">Barbadian Dollar</option>
                        <option value="BYR">Belarusian Ruble</option>
                        <option value="BEF">Belgian Franc</option>
                        <option value="BZD">Belize Dollar</option>
                        <option value="BMD">Bermudan Dollar</option>
                        <option value="BTN">Bhutanese Ngultrum</option>
                        <option value="BTC">Bitcoin</option>
                        <option value="BOB">Bolivian Boliviano</option>
                        <option value="BAM">Bosnia-Herzegovina Convertible Mark</option>
                        <option value="BWP">Botswanan Pula</option>
                        <option value="BRL">Brazilian Real</option>
                        <option value="GBP">British Pound Sterling</option>
                        <option value="BND">Brunei Dollar</option>
                        <option value="BGN">Bulgarian Lev</option>
                        <option value="BIF">Burundian Franc</option>
                        <option value="KHR">Cambodian Riel</option>
                        <option value="CAD">Canadian Dollar</option>
                        <option value="CVE">Cape Verdean Escudo</option>
                        <option value="KYD">Cayman Islands Dollar</option>
                        <option value="XOF">CFA Franc BCEAO</option>
                        <option value="XAF">CFA Franc BEAC</option>
                        <option value="XPF">CFP Franc</option>
                        <option value="CLP">Chilean Peso</option>
                        <option value="CNY">Chinese Yuan</option>
                        <option value="COP">Colombian Peso</option>
                        <option value="KMF">Comorian Franc</option>
                        <option value="CDF">Congolese Franc</option>
                        <option value="CRC">Costa Rican ColÃ³n</option>
                        <option value="HRK">Croatian Kuna</option>
                        <option value="CUC">Cuban Convertible Peso</option>
                        <option value="CZK">Czech Republic Koruna</option>
                        <option value="DKK">Danish Krone</option>
                        <option value="DJF">Djiboutian Franc</option>
                        <option value="DOP">Dominican Peso</option>
                        <option value="XCD">East Caribbean Dollar</option>
                        <option value="EGP">Egyptian Pound</option>
                        <option value="ERN">Eritrean Nakfa</option>
                        <option value="EEK">Estonian Kroon</option>
                        <option value="ETB">Ethiopian Birr</option>
                        <option value="EUR">Euro</option>
                        <option value="FKP">Falkland Islands Pound</option>
                        <option value="FJD">Fijian Dollar</option>
                        <option value="GMD">Gambian Dalasi</option>
                        <option value="GEL">Georgian Lari</option>
                        <option value="DEM">German Mark</option>
                        <option value="GHS">Ghanaian Cedi</option>
                        <option value="GIP">Gibraltar Pound</option>
                        <option value="GRD">Greek Drachma</option>
                        <option value="GTQ">Guatemalan Quetzal</option>
                        <option value="GNF">Guinean Franc</option>
                        <option value="GYD">Guyanaese Dollar</option>
                        <option value="HTG">Haitian Gourde</option>
                        <option value="HNL">Honduran Lempira</option>
                        <option value="HKD">Hong Kong Dollar</option>
                        <option value="HUF">Hungarian Forint</option>
                        <option value="ISK">Icelandic KrÃ³na</option>
                        <option value="INR">Indian Rupee</option>
                        <option value="IDR">Indonesian Rupiah</option>
                        <option value="IRR">Iranian Rial</option>
                        <option value="IQD">Iraqi Dinar</option>
                        <option value="ILS">Israeli New Sheqel</option>
                        <option value="ITL">Italian Lira</option>
                        <option value="JMD">Jamaican Dollar</option>
                        <option value="JPY">Japanese Yen</option>
                        <option value="JOD">Jordanian Dinar</option>
                        <option value="KZT">Kazakhstani Tenge</option>
                        <option value="KES">Kenyan Shilling</option>
                        <option value="KWD">Kuwaiti Dinar</option>
                        <option value="KGS">Kyrgystani Som</option>
                        <option value="LAK">Laotian Kip</option>
                        <option value="LVL">Latvian Lats</option>
                        <option value="LBP">Lebanese Pound</option>
                        <option value="LSL">Lesotho Loti</option>
                        <option value="LRD">Liberian Dollar</option>
                        <option value="LYD">Libyan Dinar</option>
                        <option value="LTL">Lithuanian Litas</option>
                        <option value="MOP">Macanese Pataca</option>
                        <option value="MKD">Macedonian Denar</option>
                        <option value="MGA">Malagasy Ariary</option>
                        <option value="MWK">Malawian Kwacha</option>
                        <option value="MYR">Malaysian Ringgit</option>
                        <option value="MVR">Maldivian Rufiyaa</option>
                        <option value="MRO">Mauritanian Ouguiya</option>
                        <option value="MUR">Mauritian Rupee</option>
                        <option value="MXN">Mexican Peso</option>
                        <option value="MDL">Moldovan Leu</option>
                        <option value="MNT">Mongolian Tugrik</option>
                        <option value="MAD">Moroccan Dirham</option>
                        <option value="MZM">Mozambican Metical</option>
                        <option value="MMK">Myanmar Kyat</option>
                        <option value="NAD">Namibian Dollar</option>
                        <option value="NPR">Nepalese Rupee</option>
                        <option value="ANG">Netherlands Antillean Guilder</option>
                        <option value="TWD">New Taiwan Dollar</option>
                        <option value="NZD">New Zealand Dollar</option>
                        <option value="NIO">Nicaraguan CÃ³rdoba</option>
                        <option value="NGN">Nigerian Naira</option>
                        <option value="KPW">North Korean Won</option>
                        <option value="NOK">Norwegian Krone</option>
                        <option value="OMR">Omani Rial</option>
                        <option value="PKR">Pakistani Rupee</option>
                        <option value="PAB">Panamanian Balboa</option>
                        <option value="PGK">Papua New Guinean Kina</option>
                        <option value="PYG">Paraguayan Guarani</option>
                        <option value="PEN">Peruvian Nuevo Sol</option>
                        <option value="PHP">Philippine Peso</option>
                        <option value="PLN">Polish Zloty</option>
                        <option value="QAR">Qatari Rial</option>
                        <option value="RON">Romanian Leu</option>
                        <option value="RUB">Russian Ruble</option>
                        <option value="RWF">Rwandan Franc</option>
                        <option value="SVC">Salvadoran ColÃ³n</option>
                        <option value="WST">Samoan Tala</option>
                        <option value="SAR">Saudi Riyal</option>
                        <option value="RSD">Serbian Dinar</option>
                        <option value="SCR">Seychellois Rupee</option>
                        <option value="SLL">Sierra Leonean Leone</option>
                        <option value="SGD">Singapore Dollar</option>
                        <option value="SKK">Slovak Koruna</option>
                        <option value="SBD">Solomon Islands Dollar</option>
                        <option value="SOS">Somali Shilling</option>
                        <option value="ZAR">South African Rand</option>
                        <option value="KRW">South Korean Won</option>
                        <option value="XDR">Special Drawing Rights</option>
                        <option value="LKR">Sri Lankan Rupee</option>
                        <option value="SHP">St. Helena Pound</option>
                        <option value="SDG">Sudanese Pound</option>
                        <option value="SRD">Surinamese Dollar</option>
                        <option value="SZL">Swazi Lilangeni</option>
                        <option value="SEK">Swedish Krona</option>
                        <option value="CHF">Swiss Franc</option>
                        <option value="SYP">Syrian Pound</option>
                        <option value="STD">São Tomé and Príncipe Dobra</option>
                        <option value="TJS">Tajikistani Somoni</option>
                        <option value="TZS">Tanzanian Shilling</option>
                        <option value="THB">Thai Baht</option>
                        <option value="TOP">Tongan pa'anga</option>
                        <option value="TTD">Trinidad & Tobago Dollar</option>
                        <option value="TND">Tunisian Dinar</option>
                        <option value="TRY">Turkish Lira</option>
                        <option value="TMT">Turkmenistani Manat</option>
                        <option value="UGX">Ugandan Shilling</option>
                        <option value="UAH">Ukrainian Hryvnia</option>
                        <option value="UYU">Uruguayan Peso</option>
                        <option value="USD">US Dollar</option>
                        <option value="UZS">Uzbekistan Som</option>
                        <option value="VUV">Vanuatu Vatu</option>
                        <option value="VEF">Venezuelan BolÃ­var</option>
                        <option value="VND">Vietnamese Dong</option>
                        <option value="YER">Yemeni Rial</option>
                        <option value="ZMK">Zambian Kwacha</option>
                        
                      </select>
                      <span id="from_currency_err" class="frm-err"></span>
                      <a href="javascript:void(0)" class="swapstyle swap-currency">To <img src="swap.jpg" class="swap_img"></a>
                    </div>
                    <div class="form-group">
                      <select name="unit_to" id="to_currency" class="form-control">
                        <option value="">Select Currency</option>
                        <option disabled="disabled" class="title">Most popular / recent</option>
                        <option value="JPY">Japanese yen (JPY)</option>
                        <option value="INR">Indian rupee (INR)</option>
                        <option value="GBP">British pound (GBP)</option>
                        <option value="EUR">Euro (EUR)</option>
                        <option value="USD">U.S. dollar (USD)</option>
                        <option disabled="disabled" class="title">All currencies</option>
                        
                        <option value="AFA">Afghan Afghani</option>
                        <option value="ALL">Albanian Lek</option>
                        <option value="DZD">Algerian Dinar</option>
                        <option value="AOA">Angolan Kwanza</option>
                        <option value="ARS">Argentine Peso</option>
                        <option value="AMD">Armenian Dram</option>
                        <option value="AWG">Aruban Florin</option>
                        <option value="AUD">Australian Dollar</option>
                        <option value="AZN">Azerbaijani Manat</option>
                        <option value="BSD">Bahamian Dollar</option>
                        <option value="BHD">Bahraini Dinar</option>
                        <option value="BDT">Bangladeshi Taka</option>
                        <option value="BBD">Barbadian Dollar</option>
                        <option value="BYR">Belarusian Ruble</option>
                        <option value="BEF">Belgian Franc</option>
                        <option value="BZD">Belize Dollar</option>
                        <option value="BMD">Bermudan Dollar</option>
                        <option value="BTN">Bhutanese Ngultrum</option>
                        <option value="BTC">Bitcoin</option>
                        <option value="BOB">Bolivian Boliviano</option>
                        <option value="BAM">Bosnia-Herzegovina Convertible Mark</option>
                        <option value="BWP">Botswanan Pula</option>
                        <option value="BRL">Brazilian Real</option>
                        <option value="GBP">British Pound Sterling</option>
                        <option value="BND">Brunei Dollar</option>
                        <option value="BGN">Bulgarian Lev</option>
                        <option value="BIF">Burundian Franc</option>
                        <option value="KHR">Cambodian Riel</option>
                        <option value="CAD">Canadian Dollar</option>
                        <option value="CVE">Cape Verdean Escudo</option>
                        <option value="KYD">Cayman Islands Dollar</option>
                        <option value="XOF">CFA Franc BCEAO</option>
                        <option value="XAF">CFA Franc BEAC</option>
                        <option value="XPF">CFP Franc</option>
                        <option value="CLP">Chilean Peso</option>
                        <option value="CNY">Chinese Yuan</option>
                        <option value="COP">Colombian Peso</option>
                        <option value="KMF">Comorian Franc</option>
                        <option value="CDF">Congolese Franc</option>
                        <option value="CRC">Costa Rican ColÃ³n</option>
                        <option value="HRK">Croatian Kuna</option>
                        <option value="CUC">Cuban Convertible Peso</option>
                        <option value="CZK">Czech Republic Koruna</option>
                        <option value="DKK">Danish Krone</option>
                        <option value="DJF">Djiboutian Franc</option>
                        <option value="DOP">Dominican Peso</option>
                        <option value="XCD">East Caribbean Dollar</option>
                        <option value="EGP">Egyptian Pound</option>
                        <option value="ERN">Eritrean Nakfa</option>
                        <option value="EEK">Estonian Kroon</option>
                        <option value="ETB">Ethiopian Birr</option>
                        <option value="EUR">Euro</option>
                        <option value="FKP">Falkland Islands Pound</option>
                        <option value="FJD">Fijian Dollar</option>
                        <option value="GMD">Gambian Dalasi</option>
                        <option value="GEL">Georgian Lari</option>
                        <option value="DEM">German Mark</option>
                        <option value="GHS">Ghanaian Cedi</option>
                        <option value="GIP">Gibraltar Pound</option>
                        <option value="GRD">Greek Drachma</option>
                        <option value="GTQ">Guatemalan Quetzal</option>
                        <option value="GNF">Guinean Franc</option>
                        <option value="GYD">Guyanaese Dollar</option>
                        <option value="HTG">Haitian Gourde</option>
                        <option value="HNL">Honduran Lempira</option>
                        <option value="HKD">Hong Kong Dollar</option>
                        <option value="HUF">Hungarian Forint</option>
                        <option value="ISK">Icelandic KrÃ³na</option>
                        <option value="INR">Indian Rupee</option>
                        <option value="IDR">Indonesian Rupiah</option>
                        <option value="IRR">Iranian Rial</option>
                        <option value="IQD">Iraqi Dinar</option>
                        <option value="ILS">Israeli New Sheqel</option>
                        <option value="ITL">Italian Lira</option>
                        <option value="JMD">Jamaican Dollar</option>
                        <option value="JPY">Japanese Yen</option>
                        <option value="JOD">Jordanian Dinar</option>
                        <option value="KZT">Kazakhstani Tenge</option>
                        <option value="KES">Kenyan Shilling</option>
                        <option value="KWD">Kuwaiti Dinar</option>
                        <option value="KGS">Kyrgystani Som</option>
                        <option value="LAK">Laotian Kip</option>
                        <option value="LVL">Latvian Lats</option>
                        <option value="LBP">Lebanese Pound</option>
                        <option value="LSL">Lesotho Loti</option>
                        <option value="LRD">Liberian Dollar</option>
                        <option value="LYD">Libyan Dinar</option>
                        <option value="LTL">Lithuanian Litas</option>
                        <option value="MOP">Macanese Pataca</option>
                        <option value="MKD">Macedonian Denar</option>
                        <option value="MGA">Malagasy Ariary</option>
                        <option value="MWK">Malawian Kwacha</option>
                        <option value="MYR">Malaysian Ringgit</option>
                        <option value="MVR">Maldivian Rufiyaa</option>
                        <option value="MRO">Mauritanian Ouguiya</option>
                        <option value="MUR">Mauritian Rupee</option>
                        <option value="MXN">Mexican Peso</option>
                        <option value="MDL">Moldovan Leu</option>
                        <option value="MNT">Mongolian Tugrik</option>
                        <option value="MAD">Moroccan Dirham</option>
                        <option value="MZM">Mozambican Metical</option>
                        <option value="MMK">Myanmar Kyat</option>
                        <option value="NAD">Namibian Dollar</option>
                        <option value="NPR">Nepalese Rupee</option>
                        <option value="ANG">Netherlands Antillean Guilder</option>
                        <option value="TWD">New Taiwan Dollar</option>
                        <option value="NZD">New Zealand Dollar</option>
                        <option value="NIO">Nicaraguan CÃ³rdoba</option>
                        <option value="NGN">Nigerian Naira</option>
                        <option value="KPW">North Korean Won</option>
                        <option value="NOK">Norwegian Krone</option>
                        <option value="OMR">Omani Rial</option>
                        <option value="PKR">Pakistani Rupee</option>
                        <option value="PAB">Panamanian Balboa</option>
                        <option value="PGK">Papua New Guinean Kina</option>
                        <option value="PYG">Paraguayan Guarani</option>
                        <option value="PEN">Peruvian Nuevo Sol</option>
                        <option value="PHP">Philippine Peso</option>
                        <option value="PLN">Polish Zloty</option>
                        <option value="QAR">Qatari Rial</option>
                        <option value="RON">Romanian Leu</option>
                        <option value="RUB">Russian Ruble</option>
                        <option value="RWF">Rwandan Franc</option>
                        <option value="SVC">Salvadoran ColÃ³n</option>
                        <option value="WST">Samoan Tala</option>
                        <option value="SAR">Saudi Riyal</option>
                        <option value="RSD">Serbian Dinar</option>
                        <option value="SCR">Seychellois Rupee</option>
                        <option value="SLL">Sierra Leonean Leone</option>
                        <option value="SGD">Singapore Dollar</option>
                        <option value="SKK">Slovak Koruna</option>
                        <option value="SBD">Solomon Islands Dollar</option>
                        <option value="SOS">Somali Shilling</option>
                        <option value="ZAR">South African Rand</option>
                        <option value="KRW">South Korean Won</option>
                        <option value="XDR">Special Drawing Rights</option>
                        <option value="LKR">Sri Lankan Rupee</option>
                        <option value="SHP">St. Helena Pound</option>
                        <option value="SDG">Sudanese Pound</option>
                        <option value="SRD">Surinamese Dollar</option>
                        <option value="SZL">Swazi Lilangeni</option>
                        <option value="SEK">Swedish Krona</option>
                        <option value="CHF">Swiss Franc</option>
                        <option value="SYP">Syrian Pound</option>
                        <option value="STD">São Tomé and Príncipe Dobra</option>
                        <option value="TJS">Tajikistani Somoni</option>
                        <option value="TZS">Tanzanian Shilling</option>
                        <option value="THB">Thai Baht</option>
                        <option value="TOP">Tongan pa'anga</option>
                        <option value="TTD">Trinidad & Tobago Dollar</option>
                        <option value="TND">Tunisian Dinar</option>
                        <option value="TRY">Turkish Lira</option>
                        <option value="TMT">Turkmenistani Manat</option>
                        <option value="UGX">Ugandan Shilling</option>
                        <option value="UAH">Ukrainian Hryvnia</option>
                        <option value="UYU">Uruguayan Peso</option>
                        <option value="USD">US Dollar</option>
                        <option value="UZS">Uzbekistan Som</option>
                        <option value="VUV">Vanuatu Vatu</option>
                        <option value="VEF">Venezuelan BolÃ­var</option>
                        <option value="VND">Vietnamese Dong</option>
                        <option value="YER">Yemeni Rial</option>
                        <option value="ZMK">Zambian Kwacha</option>
                      </select>
                      <span id="to_currency_err" class="frm-err"></span>
                      
                    </div>
                    
                    
                    <div class="result_container">
                      <div class="result" id="div_currency"></div>
                    </div>
                  </form>
                  
                </div>
                
                <div class="col-md-4 homegrid">
                  <h2>Mass</h2>
                  <form id="conv_weight" action="javascript:void(0)">
                    <div class="form-group">
                      <div class="row">
                        <div class="col-md-10 col-10">
                          <input type="number" id="weight_amount" name="weight_amount" aria-label="Amount"  placeholder="I want to convert"  class="form-control"/>
                          
                        </div>
                        <div class="col-md-2 searchbtncol col-2">
                          <button type="button" id="weight_btn" name="weight_btn" class="btn btn-warning"><i class="fa fa-search"></i></button>
                          
                        </div>
                        <span id="weight_amount_err" class="frm-err"></span>
                      </div>
                      
                    </div>
                    <div class="form-group">
                      <select name="unit_from" id="from_weight" class="form-control dropdown-first">
                        <option value="">Select Weight</option>
                        <option disabled="disabled" class="title">Metric</option>
                        <option value="t">Ton (t)</option>
                        <option value="kN">Kilonewton (kN)</option>
                        <option value="kg">Kilogram (kg)</option>
                        <option value="hg">Hectogram (hg)</option>
                        <option value="dag">Decagram (dag)</option>
                        <option value="g">Gram (g)</option>
                        <option value="karat:1">Carat</option>
                        <option value="centigram">Centigram</option>
                        <option value="mg">Milligram (mg)</option>
                        <option value="µg">Microgram (µg)</option>
                        <option value="ng">Nanogram (ng)</option>
                        <option value="u">Atomic mass unit (u)</option>
                        <option disabled="disabled">&nbsp;</option>
                        <option disabled="disabled" class="title">Avoirdupois (U.S.)</option>
                        <option value="long ton">Long ton</option>
                        <option value="short ton">Short ton</option>
                        <option value="long hundredweight">Long hundredweight</option>
                        <option value="short hundredweight">Short hundredweight</option>
                        <option value="stone">Stone</option>
                        <option value="lb">Pound (lb)</option>
                        <option value="ounce:1">Ounce</option>
                        <option value="dr">Dram (dr)</option>
                        <option value="15432.3583529414|0|gr">Grain (gr)</option>
                        <option disabled="disabled">&nbsp;</option>
                        <option disabled="disabled" class="title">Troy</option>
                        <option value="pound:1">Pound</option>
                        <option value="ounce">Ounce</option>
                        <option value="pennyweight">Pennyweight</option>
                        <option value="carat">Carat</option>
                        <option value="grain:1">Grain</option>
                        <option value="mite">Mite</option>
                        <option value="doite">Doite</option>
                        <option disabled="disabled">&nbsp;</option>
                        <option disabled="disabled" class="title">Japanese</option>
                        <option value="koku">Koku</option>
                        <option value="kann">Kann</option>
                        <option value="kinn">Kinn</option>
                        <option value="monnme">Monnme</option>
                        <option disabled="disabled">&nbsp;</option>
                        <option disabled="disabled" class="title">Chinese</option>
                        <option value="tael">Tael</option>
                        <option value="ku ping">Ku ping</option>
                        <option disabled="disabled">&nbsp;</option>
                        <option disabled="disabled" class="title">Old Swedish</option>
                        <option value="skeppspund">Skeppspund</option>
                        <option value="lispund">Lispund</option>
                        <option value="skålpund">Skålpund</option>
                        <option value="mark">Mark</option>
                        <option value="uns">Uns</option>
                        <option value="lod">Lod</option>
                      </select>
                      <span id="from_weight_err" class="frm-err"></span>
                      <a href="javascript:void(0)" class="swapstyle swap-weight">To <img src="swap.jpg" class="swap_img"></a>
                      
                    </div>
                    <div class="form-group">
                      
                      <select name="unit_to" id="to_weight" class="form-control">
                        <option value="">Select Weight</option>
                        <option disabled="disabled" class="title">Metric</option>
                        <option value="t">Ton (t)</option>
                        <option value="kN">Kilonewton (kN)</option>
                        <option value="kg">Kilogram (kg)</option>
                        <option value="hg">Hectogram (hg)</option>
                        <option value="dag">Decagram (dag)</option>
                        <option value="g">Gram (g)</option>
                        <option value="karat:1">Carat</option>
                        <option value="centigram">Centigram</option>
                        <option value="mg">Milligram (mg)</option>
                        <option value="µg">Microgram (µg)</option>
                        <option value="ng">Nanogram (ng)</option>
                        <option value="u">Atomic mass unit (u)</option>
                        <option disabled="disabled">&nbsp;</option>
                        <option disabled="disabled" class="title">Avoirdupois (U.S.)</option>
                        <option value="long ton">Long ton</option>
                        <option value="short ton">Short ton</option>
                        <option value="long hundredweight">Long hundredweight</option>
                        <option value="short hundredweight">Short hundredweight</option>
                        <option value="stone">Stone</option>
                        <option value="lb">Pound (lb)</option>
                        <option value="ounce:1">Ounce</option>
                        <option value="dr">Dram (dr)</option>
                        <option value="15432.3583529414|0|gr">Grain (gr)</option>
                        <option disabled="disabled">&nbsp;</option>
                        <option disabled="disabled" class="title">Troy</option>
                        <option value="pound:1">Pound</option>
                        <option value="ounce">Ounce</option>
                        <option value="pennyweight">Pennyweight</option>
                        <option value="carat">Carat</option>
                        <option value="grain:1">Grain</option>
                        <option value="mite">Mite</option>
                        <option value="doite">Doite</option>
                        <option disabled="disabled">&nbsp;</option>
                        <option disabled="disabled" class="title">Japanese</option>
                        <option value="koku">Koku</option>
                        <option value="kann">Kann</option>
                        <option value="kinn">Kinn</option>
                        <option value="monnme">Monnme</option>
                        <option disabled="disabled">&nbsp;</option>
                        <option disabled="disabled" class="title">Chinese</option>
                        <option value="tael">Tael</option>
                        <option value="ku ping">Ku ping</option>
                        <option disabled="disabled">&nbsp;</option>
                        <option disabled="disabled" class="title">Old Swedish</option>
                        <option value="skeppspund">Skeppspund</option>
                        <option value="lispund">Lispund</option>
                        <option value="skålpund">Skålpund</option>
                        <option value="mark">Mark</option>
                        <option value="uns">Uns</option>
                        <option value="lod">Lod</option>
                        
                      </select>
                      <span id="to_weight_err" class="frm-err"></span>
                      
                      
                    </div>
                    
                    
                    <div class="result_container">
                      <div class="result" id="div_weight"></div>
                    </div>
                  </form>
                </div>
                <div class="col-md-4 homegrid">
                  <h2>Area</h2>
                  <form id="conv_area" action="javascript:void(0)">
                    <div class="form-group">
                      <div class="row">
                        <div class="col-md-10 col-10">
                          <input type="number" id="area_amount" name="area_amount" aria-label="Amount" class="form-control" placeholder="I want to convert" >
                          
                        </div>
                        <div class="col-md-2 searchbtncol col-2">
                          <button type="button" id="area_btn" name="area_btn" class="btn btn-warning"><i class="fa fa-search"></i></button>
                          
                        </div>
                        
                        <span id="area_amount_err" class="frm-err"></span>
                      </div>
                    </div>
                    <div class="form-group">
                      <select name="unit_from" id="from_area" class="form-control dropdown-first">
                        <option value="">Select Area</option>
                        <option disabled="disabled" class="title">Metric</option>
                        <option value="km²">Square kilometre</option>
                        <option value="ha">Hectare (ha)</option>
                        <option value="a">Are (a)</option>
                        <option value="m²">Square metre</option>
                        <option value="dm²">Square decimetre</option>
                        <option value="cm²">Square centimetre (cm²)</option>
                        <option value="mm²">Square millimetre</option>
                        <option value="µm²">Square micrometre</option>
                        <option value="nm²">Square nanometre</option>
                        <option disabled="disabled">&nbsp;</option>
                        <option disabled="disabled" class="title">British/American</option>
                        <option value="township">Township</option>
                        <option value="square mile">Square mile</option>
                        <option value="homestead">Homestead</option>
                        <option value="acre">Acre</option>
                        <option value="rood">Rood</option>
                        <option value="square rod">Square rod</option>
                        <option value="square">Square</option>
                        <option value="yr²">Square yard (yr²)</option>
                        <option value="ft²">Square foot (ft²)</option>
                        <option value="in²">Square inch (in²)</option>
                        <option disabled="disabled">&nbsp;</option>
                        <option disabled="disabled" class="title">Japanese</option>
                        <option value="tsubo">Tsubo</option>
                        <option value="cho">Cho</option>
                        <option value="tann">Tann</option>
                        <option value="se">Se</option>
                        <option disabled="disabled">&nbsp;</option>
                        <option disabled="disabled" class="title">Other</option>
                        <option value="metric_dunam">Metric dunam</option>
                        <option value="cypriot_dunam">Cypriot dunam</option>
                        <option value="iraqi_dunam">Iraqi dunam</option>
                        <option value="greek_stremma">Greek stremma</option>
                        <option value="football_pitch">Football pitch</option>
                      </select>
                      <span id="from_area_err" class="frm-err"></span>
                      <a href="javascript:void(0)" class="swapstyle swap-area">To <img src="swap.jpg" class="swap_img"></a>
                      
                    </div>
                    <div class="form-group">
                      
                      <select name="unit_to" id="to_area" class="form-control">
                        <option value="">Select Area</option>
                        <option disabled="disabled" class="title">Metric</option>
                        <option value="km²">Square kilometre</option>
                        <option value="ha">Hectare (ha)</option>
                        <option value="a">Are (a)</option>
                        <option value="m²">Square metre</option>
                        <option value="dm²">Square decimetre</option>
                        <option value="cm²">Square centimetre (cm²)</option>
                        <option value="mm²">Square millimetre</option>
                        <option value="µm²">Square micrometre</option>
                        <option value="nm²">Square nanometre</option>
                        <option disabled="disabled">&nbsp;</option>
                        <option disabled="disabled" class="title">British/American</option>
                        <option value="township">Township</option>
                        <option value="square mile">Square mile</option>
                        <option value="homestead">Homestead</option>
                        <option value="acre">Acre</option>
                        <option value="rood">Rood</option>
                        <option value="square rod">Square rod</option>
                        <option value="square">Square</option>
                        <option value="yr²">Square yard (yr²)</option>
                        <option value="ft²">Square foot (ft²)</option>
                        <option value="in²">Square inch (in²)</option>
                        <option disabled="disabled">&nbsp;</option>
                        <option disabled="disabled" class="title">Japanese</option>
                        <option value="tsubo">Tsubo</option>
                        <option value="cho">Cho</option>
                        <option value="tann">Tann</option>
                        <option value="se">Se</option>
                        <option disabled="disabled">&nbsp;</option>
                        <option disabled="disabled" class="title">Other</option>
                        <option value="metric_dunam">Metric dunam</option>
                        <option value="cypriot_dunam">Cypriot dunam</option>
                        <option value="iraqi_dunam">Iraqi dunam</option>
                        <option value="greek_stremma">Greek stremma</option>
                        <option value="football_pitch">Football pitch</option>
                      </select>
                      <span id="to_area_err" class="frm-err"></span>
                      
                    </div>
                    
                    
                    <div class="result_container mini_result_container">
                      <div class="result" id="div_area"></div>
                    </div>
                  </form>
                </div>
                <div class="col-md-4 homegrid">
                  <h2>Speed</h2>
                  <form id="conv_speed" action="javascript:void(0)">
                    <div class="form-group">
                      <div class="row">
                        <div class="col-md-10 col-10">
                          <input type="number" id="speed_amount" name="speed_amount" aria-label="Amount"  placeholder="I want to convert"  class="form-control">
                          
                        </div>
                        <div class="col-md-2 searchbtncol col-2">
                          <button type="button" id="speed_btn" name="speed_btn" class="btn btn-warning"><i class="fa fa-search"></i></button>
                          
                        </div>
                        <span id="speed_amount_err" class="frm-err"></span>
                      </div>
                      
                    </div>
                    <div class="form-group">
                      <select name="unit_from" id="from_speed" class="form-control dropdown-first">
                        <option value="">Select Speed</option>
                        <option disabled="disabled" class="title">Metric</option>
                        <option value="km/s">Kilometre per second</option>
                        <option value="m/s">Metre per second</option>
                        <option value="km/h">Kilometre per hour</option>
                        <option value="mm/s">Millimetre per second (mm/s)</option>
                        <option value="µm/s">Micrometre per second (µm/s)</option>
                        <option disabled="disabled">&nbsp;</option>
                        <option disabled="disabled" class="title">British/American</option>
                        <option value="mile per second">Mile per second</option>
                        <option value="mph">Mile per hour (mph)</option>
                        <option value="foot per second">Foot per second</option>
                        <option disabled="disabled">&nbsp;</option>
                        <option disabled="disabled" class="title">Nautical</option>
                        <option value="knot">Knot</option>
                        <option disabled="disabled">&nbsp;</option>
                        <option disabled="disabled" class="title">Other</option>
                        <option value="speed of light">Speed of light</option>
                        <option value="speed of sound">Speed of sound</option>
                        <option value="speed of walk">A brisk walk</option>
                        <option value="speed of snail">Speed of a common snail</option>
                      </select>
                      <span id="from_speed_err" class="frm-err"></span>
                      <a href="javascript:void(0)" class="swapstyle swap-speed">To <img src="swap.jpg" class="swap_img"></a>
                    </div>
                    <div class="form-group">
                      
                      <select name="unit_to" id="to_speed" class="form-control">
                        <option value="">Select Speed</option>
                        <option disabled="disabled" class="title">Metric</option>
                        <option value="km/s">Kilometre per second</option>
                        <option value="m/s">Metre per second</option>
                        <option value="km/h">Kilometre per hour</option>
                        <option value="mm/s">Millimetre per second (mm/s)</option>
                        <option value="µm/s">Micrometre per second (µm/s)</option>
                        <option disabled="disabled">&nbsp;</option>
                        <option disabled="disabled" class="title">British/American</option>
                        <option value="mile per second">Mile per second</option>
                        <option value="mph">Mile per hour (mph)</option>
                        <option value="foot per second">Foot per second</option>
                        <option disabled="disabled">&nbsp;</option>
                        <option disabled="disabled" class="title">Nautical</option>
                        <option value="knot">Knot</option>
                        <option disabled="disabled">&nbsp;</option>
                        <option disabled="disabled" class="title">Other</option>
                        <option value="speed of light">Speed of light</option>
                        <option value="speed of sound">Speed of sound</option>
                        <option value="speed of walk">A brisk walk</option>
                        <option value="speed of snail">Speed of a common snail</option>
                      </select>
                      <span id="to_speed_err" class="frm-err"></span>
                    </div>
                    <div class="result_container">
                      <div class="result" id="div_speed"></div>
                    </div>
                  </form>
                </div>
              </div>
            </div>
          </div>
              <!-- feed-->
   @include('includes.feeds')
  
        </div>

    <!-- feed-->
    <div class="col-md-2"><?php echo $ads->right_ads;?> </div>
  </div>
</div>
</section><!-- End Pricing Section -->
<div class="col-lg-12">
  <?php echo $ads->footer_ads;?>
</div>
</main><!-- End #main -->
@stop
