<?php

namespace App\Http\Controllers;

//use App\Models\Admin;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Hash;
use DB;
class AdminController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

  
  // Use for show Dashbaord Page

  public function showDashboardPage()
   {
     
     $total_contact=DB::table('contact')->get()->count();
     $total_convert =  DB::table('front_page')->where('id',8)->first();
  
      return view('dashboard',['total_contact'=>$total_contact,'total_convert'=>$total_convert]);
     

   }


  // Use for show change password page
   public function showChangePassword()
   {
     
      return view('profile.changepassword');

   }

  // Use for update admin password 
   public function updatePassword(Request $request)
   {
   	       $user               =           Auth::user();
           $request->validate(
            [
                'old_password'              =>      'required',
                'new_password'          =>      'required|alpha_num|min:8',
                'confirm_password'  =>      'required|same:new_password'
            ]
        );
 
        $users = DB::table('users')->where('id', $user->id)->first();

       if(!is_null($users))
        {

        	 $old_password = $request->old_password;
    $new_password = $request->new_password;
    $confirm_password = $request->confirm_password;
            if(!Hash::check($old_password, $user->password))
            {

              return back()->with("failed", "Old Password Does not Match"); 	
             //return redirect('changepassword')->with('Error', 'Old Password Does not Match');
            }
            else
            {
          
            $securePassword = array('password'=>bcrypt($new_password));
            DB::table('users')->where('id',$user->id)->update($securePassword);
            
            return redirect('/admin/login')->with('success', 'Your password succuessfully changed');
            }
            
        }

        else
        {
            return back()->with("failed", "Alert! Failed to update password");
        }    

   }


 
 // Use for show about page content
   public function showAboutPage()
   {
     $aboutus =  DB::table('front_page')->where('id',1)->first();
            
      return view('pages.about',['aboutus'=>$aboutus]);

   }
    
 // Use for update about page content
   public function updateAboutPage(Request $request)
   {
     
         $request->validate(
            [
                'title'              =>      'required',
                'content'          =>      'required'
            ]
        );

        
       $updateData=['title'=>$request->title,'content'=>$request->content];

       DB::table('front_page')->where('id',1)->update($updateData);
        return redirect('/admin/aboutus')->with('success', 'Succuessfully saved');
           
   }

 // Use for show contact page content
   public function showContactPage()
   {
     $contact =  DB::table('front_page')->where('id',7)->first();
            
      return view('pages.contact',['contact'=>$contact]);

   }
    
 // Use for update contact page content
   public function updateContactPage(Request $request)
   {
     
         $request->validate(
            [
                'location'              =>      'required',
                'email'              =>      'required',
                'phoneno'              =>      'required'
            ]
        );

        
       $updateData=['location'=>$request->location,'email'=>$request->email,'phoneno'=>$request->phoneno,'map'=>$request->map];

       DB::table('front_page')->where('id',7)->update($updateData);
        return redirect('/admin/contact')->with('success', 'Succuessfully saved');
           
   }



  // Use for show dcma copyright page content
   public function showDcmaPage()
   {
     $dcma =  DB::table('front_page')->where('id',2)->first();
            
      return view('pages.dcma',['dcma'=>$dcma]);

   }

  // Use for update dcma copyright page content
   public function updateDcmaPage(Request $request)
   {
     
         $request->validate(
            [
                'title'              =>      'required',
                'content'          =>      'required'
            ]
        );
     
        $updateData=['title'=>$request->title,'content'=>$request->content];

       DB::table('front_page')->where('id',2)->update($updateData);
        return redirect('/admin/dcma')->with('success', 'Succuessfully saved');
           
   }


 // Use for show privacy policy page content
   public function showPrivacyPolicyPage()
   {
     $privacy =  DB::table('front_page')->where('id',3)->first();
            
      return view('pages.privacy',['privacy'=>$privacy]);

   }

 // Use for update privacy policy page content
   public function updatePrivacyPage(Request $request)
   {
     
         $request->validate(
            [
                'title'              =>      'required',
                'content'          =>      'required'
            ]
        );
     
        $updateData=['title'=>$request->title,'content'=>$request->content];

       DB::table('front_page')->where('id',3)->update($updateData);
        return redirect('/admin/privacypolicy')->with('success', 'Succuessfully saved');
           
   }

// Use for show terms and condition page content
   public function showTermsPage()
   {
     $terms =  DB::table('front_page')->where('id',4)->first();
            
      return view('pages.terms',['terms'=>$terms]);

   }

// Use for update terms and condition page content
   public function updateTermsPage(Request $request)
   {
     
         $request->validate(
            [
                'title'              =>      'required',
                'content'          =>      'required'
            ]
        );
     
        $updateData=['title'=>$request->title,'content'=>$request->content];

       DB::table('front_page')->where('id',4)->update($updateData);
        return redirect('/admin/terms')->with('success', 'Succuessfully saved');
           
   }



   public function uploadImage(Request $request)
   {
    $image = $request->image;
    if(!empty($image))
     {  
        $valid_exts = array('jpeg', 'jpg', 'png');
                                   
	    // get file extension
	    $ext = $image->getClientOriginalExtension();

       if (in_array($ext, $valid_exts)) 
      {    
        $destinationPath = public_path().'/uploads/';
        $filename = str_random(6).'_'.$image->getClientOriginalName();
        //$path = url('/').'/uploads/'.'offers_image/'.$filename;
        $image->move($destinationPath, $filename);
        
        echo $thumb = public_path().'/uploads/'.$filename;
         echo  $thumbpath = url('/').'/uploads/'.$filename;
      
       } 
   
      }
   }


  // Use for show api key on page
   public function showApiKeyPage()
   {
       $apiKey =  DB::table('front_page')->where('id',5)->first();
            
      return view('pages.apikey',['apiKey'=>$apiKey]);


   }  


// Use for update api key on page
   public function updateApiKeyPage(Request $request)
   {
     
         $request->validate(
            [
                'api_key'              =>      'required'
            ]
        );
     
        $updateData=['api_key'=>$request->api_key];

       DB::table('front_page')->where('id',5)->update($updateData);
        return redirect('/admin/apiKey')->with('success', 'Succuessfully saved');
           
   }

// Use for show  header ads on page
   public function showHeaderAdsPage()
   {
       $header_ads =  DB::table('front_page')->where('id',6)->first();
            
      return view('pages.header_ads',['header_ads'=>$header_ads]);


   }  


// Use for update header ads on page
   public function updateHeaderAdsPage(Request $request)
   {
        $header_ads= $request->header_ads;

        $header_ads = str_replace('keywrd','script',$header_ads);          
     
        $updateData=['header_ads'=>$header_ads];
     
        DB::table('front_page')->where('id',6)->update($updateData);
        
        return response()->json(['success'=>"Succuessfully saved"]);
      
     
     
           
   }


// Use for show footer ads on page
   public function showFooterAdsPage()
   {
       $footer_ads =  DB::table('front_page')->where('id',6)->first();
            
      return view('pages.footer_ads',['footer_ads'=>$footer_ads]);


   }  


// Use for update footer ads on page
   public function updateFooterAdsPage(Request $request)
   {
     
        $footer_ads= $request->footer_ads;

        $footer_ads = str_replace('keywrd','script',$footer_ads);          
     
        $updateData=['footer_ads'=>$footer_ads];

        DB::table('front_page')->where('id',6)->update($updateData);
       
        return response()->json(['success'=>"Succuessfully saved"]);
     
          
   }


// Use for show left ads on page
   public function showLeftAdsPage()
   {
       $left_ads =  DB::table('front_page')->where('id',6)->first();
            
      return view('pages.left_ads',['left_ads'=>$left_ads]);


   }  


// Use for update left ads on page
   public function updateLeftAdsPage(Request $request)
   {
     
      
       $left_ads= $request->left_ads;

       $left_ads = str_replace('keywrd','script',$left_ads);          
     
       $updateData=['left_ads'=>$left_ads];

       DB::table('front_page')->where('id',6)->update($updateData);
       
       return response()->json(['success'=>"Succuessfully saved"]);
      
      
   }

// Use for show right ads on page
   public function showRightAdsPage()
   {
       $right_ads =  DB::table('front_page')->where('id',6)->first();
            
      return view('pages.right_ads',['right_ads'=>$right_ads]);


   }  


// Use for show right ads on page
   public function updateRightAdsPage(Request $request)
   {
     
        $right_ads= $request->right_ads;

        $right_ads = str_replace('keywrd','script',$right_ads);          
     
        $updateData=['right_ads'=>$right_ads];
        
        DB::table('front_page')->where('id',6)->update($updateData);
       
        return response()->json(['success'=>"Succuessfully saved"]);
      
     
     
   }



 

// Use for show head section on page
   public function showHeadSectionPage()
   {
       $head_section =  DB::table('front_page')->where('id',6)->first();
            
      return view('pages.head_section',['head_section'=>$head_section]);


   }  


// Use for show head section on page
   public function updateHeadSectionPage(Request $request)
   {
     
        $head_section= $request->head_section;

        $head_section = str_replace('keywrd','script',$head_section);          
     
        $updateData=['head_section'=>$head_section,'meta_keyword'=>$request->meta_keyword,'meta_description'=>$request->meta_description];

         DB::table('front_page')->where('id',6)->update($updateData);
       
         return response()->json(['success'=>"Succuessfully saved"]);
     
     
   }




// Use for show contact list on page
  public function showContactListPage()
   {
       $contact_list =  DB::table('contact')->orderBy('id', 'DESC')->get();
             
      return view('pages.contact_list',['contact_list'=>$contact_list]);


   }  

// Use for delete contact on page
   public function deleteContact(Request $request)
   {
      $id=$request->id;

      DB::table('contact')->where('id', $id)->delete();
      return redirect('/admin/contactList')->with('success', 'Deleted succuessfully');
   
   }

// Use for show blog list page 
   public function showFeedListPage()
   {
     $feeds =  DB::table('feeds')->orderBy('id', 'DESC')->get();
            
      return view('pages.blog_list',['feed_list'=>$feeds]);

   }
   
  
  // Use for delete feed on page
   public function deleteFeed(Request $request)
   {
      $id=$request->id;
    
      DB::table('feeds')->where('id', $id)->delete();
      return redirect('/admin/feedList')->with('success', 'Deleted succuessfully');
   
   }

    // Use for edit feed page
   public function editFeedPage(Request $request,$id)
   {
     $feeds =  DB::table('feeds')->where('id',$id)->first();
            
      return view('pages.editBlog',['feeds'=>$feeds]);

   }

 // Use for update privacy policy page content
   public function updateFeedPage(Request $request)
   {
     
         $request->validate(
            [
                'title'              =>      'required',
                'description'        =>      'required',
                'content'            =>      'required'
            ]
        );
       
       $id = $request->id;
       $title=$request->title;
       $slug = self::slugify($title);
        

     $file = $request->image;
     if(!empty($file))
         {
          $extension = $file->getClientOriginalExtension();
          $allowed =  array('png','jpg','jpeg');
          if(in_array($extension,$allowed) ) 
           {
               $filename = time().'.'.$extension;  
               $path = url('/').'/uploads/'.$filename;
               $file->move(public_path('uploads'), $filename);
           }
           else
            {
               return back()->with("Error", "Please provide the jpg,jpeg,png");  
               //return redirect('profile')->with('Error', 'Please provide the jpg,jpeg,gif,png');
            }
       }
       else
       {
           $feeds =  DB::table('feeds')->where('id',$id)->first();
           $path = $feeds->image;
        
       }
   
        $updateData=['title'=>$title,'description'=>$request->description,'content'=>$request->content,'image'=>$path];

       DB::table('feeds')->where('id',$id)->update($updateData);
        return redirect('/admin/feedList')->with('success', 'Succuessfully saved');
           
   }


public function slugify($string){
        return strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $string), '-'));
}

 
}


